
@extends('accounts.layouts.admin')

@section('title', trans('general.title.new', ['type' => trans_choice('general.invoices', 1)]))
<style>
 .card-DboardStats {
    width: 140px !important;
    min-height: 45px !important;
    margin: 0px !important;
    padding: 0px !important;
}
 .custom-control {display:inline-block !important; min-height:0 !important;padding-left:9.2rem !important;}
.custom-control.overflow-checkbox .overflow-control-indicator {
  
    position: absolute;
    top: 8px !important;
    left: 6px !important;
   
}
 </style>
@section('content')
<!-- Default box -->
{!! Form::open(['url' => 'incomes/invoices', 'files' => true, 'role' => 'form']) !!}
    <div class="card">
        
        <div class="row">


            <div class="col-lg-3 col-md-4 col-sm-4 {{ $errors->has('customer_id') ? 'has-error' : ''}}">
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-10 pr-0">
                        <div class="add-cust">
                        <small> Customer</small>
                        <select id="customer_id" name="customer_id"  class="selectpicker"tabindex="-98" data-live-search="true" required>
                              @include('accounts.common.subloop', ['name' => trans('general.form.select.field', ['field' => 'Customers'])])     
                        </select>
                        {!! $errors->first('customer_id', '<p class="help-block">:message</p>') !!}
                       </div>
                   </div>
                    <div class="col-lg-2 col-md-2 col-sm-2 pr-0">
                        <div class="add-bttn pr-0">
                         <button type="button" data-toggle="modal" data-target="#modal-create-customer"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i></button>
                        </div>
                    </div>
                </div>
            </div> 
            {!!   Form::hidden('customer_invoice_parent_id',null,['id' => 'customer_invoice_parent_id'])   !!}

            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group">
                        <input class="form-control"  name="customer_email" id="customer_email" type="text">
                        <label for="customer_email" class="form-label">Email</label>
                        <span class="form-controlBrd"></span>
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block" style="position: absolute; top: 50px;left: 0;">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator" style="top:2px;"></span> <span class="overflow-control-description"> Send Later</span><a href="#"  data-toggle="modal" data-target="#modal-another-email" > Cc <span id="cc_count" style="display: none"></span>/Bcc <span id="bcc_count" style="display: none"></span></a>  </label>
                        </div> 
                         
                        <input type="hidden" name="cc_email" id="cc_email">
                        <input type="hidden" name="bcc_email" id="bcc_email">
                    </div>
                </div>
            </div>
               {{--  {{ Form::textGroup('customer_email', trans('general.email'), 'envelope', []) }} --}}

            {!! Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) !!}
          
            <div class="col-lg-3 col-md-4 col-sm-6  {{ $errors->has('net_term') ? 'has-error' : ''}}">
                <div class="row">
                    <div class="col-md-10 pr-0">
                        <div class="add-cust">
                            <small>Terms</small>
                            {!! Form::select('net_term', $terms,null, array_merge(['id'=>'net_term','class' => 'selectpicker', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]),'required','data-live-search'=>'true' ] )) !!}  
                            {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}       
                        </div> 
                    </div> 
                    <div class="col-md-2 pl-0 pr-0">
                        <div class="add-bttn">
                         <button type="button" data-toggle="modal" id="modal-create-term-button" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;padding:0px;">add </i></button>
                        </div>
                    </div>
                </div>
            </div>



            {{ Form::textGroup('invoice_number', trans('invoices.invoice_number'), 'file-text-o', ['required' => 'required'], $number) }}

            {{ Form::textGroup('invoiced_at', trans('invoices.invoice_date'), 'calendar',['id' => 'invoiced_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->format($date_format) ) }}            

            {{ Form::textGroup('due_at', trans('invoices.due_date'), 'calendar',['id' => 'due_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '']) }}
        </div>
        <div class="row">

            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                    <textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address"></textarea>
                    <label for="address" class="form-label">{{trans('general.billingaddress')}}</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>
            

            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                {{ Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea shipping_address' , 'id'=> 'shipping_address' ,'rows' => 3]) }}
                <label for="shipping_address" class="form-label">Shipping Address</label>
                 <span class="form-controlBrd"></span>
                </div>
            </div>
        </div>
        <input type="hidden" id="customer_timesheet">
    </div> 
    {{-- Timesheet Display --}}
    <div id="time_card" >
    
         
    </div>
    {{-- Timesheet Hours  Display --}}
    <div id="timesheetdetails" >
  
        <table class="table table-bordered tabl-input table-striped">
            <thead>
                <tr>
                    <th width="10%"></th>
                    <th width="10%">Mon</th>
                    <th width="10%">Tue</th>
                    <th width="10%">Wed</th>
                    <th width="10%">Thu</th>
                    <th width="10%">Fri</th>
                    <th width="10%">Sat</th>
                    <th width="10%">Sun</th>
                    <th width="10%">Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th width="8%">Week 1</th>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div> 
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="12%">
                        <div class="card-DboardStats flex-column  text-center"> 
                            
                                <label class="custom-control overflow-checkbox">
                                   <input type="checkbox" name="approvetimesheet[]" id="monday_2" value="8" class="overflow-control-input"> 
                                   <span class="overflow-control-indicator"></span>
                                   <span class="overflow-control-description"></span> 
                                </label>
                         
                            <span class="inv-amount">8:00 REG</span>
                            <span class="inv-text">09-09-2019</span> 
                        </div>
                    </td>
                    <td width="8%">
                        
                    </td>
                </tr>
            </tbody>
        </table>
           
    </div>
    
    <div class=" ">
        <h3 class="item-title">Items</h3>
        <div class="">
            <table class="table table-bordered tabl-input table-striped" id="items">
              <thead>
                    <tr style="background-color: #f9f9f9;">
                        <th width="5%">{{ trans('general.actions') }}</th>
                        <th width="25%">{{ trans('general.name') }}</th>
                        <th width="25%">{{ trans('general.description') }}</th>
                        <th width="15%">{{ trans('invoices.quantity') }}</th>
                        <th width="15%">{{ trans('invoices.price') }}</th>
                        <th width="15%">{{ trans('invoices.total') }}</th>
                    </tr>
                </thead>
                <tbody>
                    
                    <?php $item_row = 0; ?>
                    <tr id="item-row-{{ $item_row }}">
                        <td>
                            <button type="button" onclick="$('#item-row-{{ $item_row }}').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons" >delete </i></button>
                        </td>
                       <td >
                           <select onchange="autoItem({{ $item_row }})" id="item-id-{{ $item_row }}" required="required" class="selectpicker" name="item[{{ $item_row }}][item_id]"  data-live-search="true" >
                                @include('accounts.common.subitem',['name' => trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) ])
                            </select>
                            <input class="form-control"   name="item[{{ $item_row }}][name]" type="hidden" id="item-name-{{ $item_row }}">
                            
                            
                            <input class="form-control"   name="item[{{ $item_row }}][chartid]" type="hidden" id="item-chartid-{{ $item_row }}">
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">
                                <label class="form-label">{{  trans('general.description') }} </label>
                                <span class="form-controlBrd"></span>
                            </div>
                            
                        </td>
                       <td>
                            <div class="form-group">
                                <input class="form-control" required="required" name="item[{{ $item_row }}][quantity]" type="text" id="item-quantity-{{ $item_row }}">
                                <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control price"  required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
                             <label class="form-label">Price</label>
                            <span class="form-controlBrd"></span>
                        </div>

                           
                        </td>
                        <td>
                            <span id="item-total-{{ $item_row }}">0</span>
                        </td>
                    </tr>
                    <?php $item_row++; ?>
                    <tr id="addItem">
                        <td><button type="button" onclick="addItem();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add </i></button></td>
                        <td class="text-right" colspan="5"></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="5"><strong>{{ trans('invoices.sub_total') }}</strong></td>
                        <td class="text-right"><span id="sub-total">0</span></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="5"><strong>{{ trans('invoices.total') }}</strong></td>
                        <td class="text-right"><span id="grand-total">0</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}

    {{ Form::fileGroup('attachment', trans('general.attachment')) }}


    <div class="col-md-12">
        <div class="form-group no-margin text-right">
            <button class="btn mr-3 btn-default waves-effect waves-gray" type="reset"> Reset</button>
            <a href="{{ url('incomes/invoices') }}" class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
            <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
        </div>
    </div> 

   {{--  {{ Form::saveButtons('incomes/invoices') }} --}}

    <!-- /.box-footer -->
{!! Form::close() !!}

<!-- Create Customer Model -->
<div class="modal fade" id="modal-create-customer"  >
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.customers', 1)]) }}</h4>
            </div>
            <div class="modal-body">
            {!! Form::open(['id' => 'form-create-customer', 'role' => 'form']) !!}
                <div class="row">
                    <div class="col-md-6">    
                        <div class="form-group  required">
                          <input class="form-control"  required name="name" type="text" id="name">
                          <label class="form-label">{{ trans('general.name') }}</label>
                          <span class="form-controlBrd"></span>
                          <div class="help-block with-errors"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                             <input class="form-control" required name="customer_email" type="text" id="email">
                             <label for="email" class="form-label">{{ trans('general.email') }}</label>
                             <span class="form-controlBrd"></span>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group required">
                             <small>{{  trans_choice('general.net_term', 1) }} </small>
                             {!! Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker net_term','id'=>'net_term_model','data-live-search'=>'true' ,'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                            <input class="form-control"  name="phone" id="phone" type="text">
                            <label for="phone" class="form-label">Phone</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group ">
                           <div class="custom-controls-stacked d-block">
                                <label class="custom-control overflow-checkbox" >
                                <input type="checkbox"  name="subcustomer" id="subcustomer" value="1" class="overflow-control-input">
                                <span class="overflow-control-indicator"></span> <small >  Is sub-customer</small> </label>
                            </div>
                            <select id="customer_id_save" name="customer_id_save"  class="selectpicker"  data-live-search="true" disabled="disabled">
                                <option value="" selected="">- Select Sub Customer -</option>
                                <?php echo subcustomertree($customers , $prefix = ''); ?>
                            </select>
                        </div>
                    </div>
                    @php 
                         function subcustomertree($elements, $prefix = '') {
                            foreach ($elements as $k=> $element) { 
                                @endphp
                                <option value="{{ $element['id'] }}">
                                    {{ $prefix . $element['name'] }} 
                                    @if (isset($element['children']))
                                        @php subcustomertree($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
                                        @endphp
                                    @endif
                                </option>
                            @php  } 
                        }
                    @endphp
                    <div class="col-md-6">
                        <div class="form-group ">
                            <small>Bill To</small>
                            {!! Form::select('bill_to', ['parent' => 'Bill With Parent' ,'customer' => 'Bill With Customer'], null, array_merge(['class' => 'selectpicker','id'=>'bill_to','disabled'=>'disabled'])) !!}
                        </div>
                    </div>
                    {!! Form::hidden('enabled', '1', []) !!}
                    {!! Form::hidden('currency_code', setting('general.default_currency') , ['id' =>'currency_code']) !!}
                    <div class="col-md-6">
                        <div class="form-groupTextArea ">
                          <textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address1"></textarea>
                          <label for="address" class="form-label">{{ trans('general.billingaddress') }}</label>
                          <span class="form-controlBrd"></span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-groupTextArea  ">
                             
                            {!!  Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea shipping_address', 'id'=> 'shipping_address_customer' ,'rows' => 3]) !!}
                                <label for="shipping_address" class="form-label">Shipping Address</label>
                                <span class="form-controlBrd"></span>
                                <div class="help-block with-errors">
                                     <div class="custom-controls-stacked d-block">
                                        <label class="custom-control overflow-checkbox" >
                                        <input type="checkbox" name="same_as_billing" id="same_as_billingvalue"value="1" class="overflow-control-input">
                                        <span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Same as billing address </span> </label>
                                    </div> 
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
            <div class="modal-footer">
                <div class="pull-left">
                  <button type="button" id="close-modal-create-customer" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
                  {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-customer', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Create Net Term Model -->
<div class="modal fade" id="modal-create-term" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.net_term', 1)]) }}</h4>
          </div>
          <div class="modal-body">
              {!! Form::open(['id' => 'form-create-term', 'role' => 'form']) !!}
              <div class="row">
                    <div class="col-md-6 "> 
                      <div class="form-group required">      
                            <input class="form-control" required name="name" type="text" id="name">
                            <label for="name" class="form-label">{{ trans('general.name') }}</label>
                            <span class="form-controlBrd"></span>
                      </div>
                    </div>
                    <div class="col-md-6 required">
                        <div class="form-group ">
                            <input class="form-control" required name="term_days" type="text" id="term_days">
                            <label for="name" class="form-label">Due in fixed number of days</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
              </div>
              {!! Form::close() !!}
          </div>
          <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
              {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
              </div>
          </div>
      </div>
  </div>
</div>
<!-- Create Time Sheet Model -->
<div class="modal fade" id="modal-timesheet" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title">Customer Time Sheet</h4>
          </div>
          <div class="modal-body">
              {!! Form::open(['id' => 'form-create-timesheet', 'role' => 'form']) !!}
              
              {!! Form::close() !!}
          </div>
          <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-timesheet" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
              {!! Form::button('Add', ['type' => 'button', 'id' =>'button-create-timesheet', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
              </div>
          </div>
      </div>
  </div>
</div>
{{-- Another Mail Model --}}
<div class="modal fade" id="modal-another-email" >
   <div class="modal-dialog">
      <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">CC/BCC Email (Separate emails with a comma)</h4>
          </div>
          <div class="modal-body">
              {!! Form::open(['id' => 'form-another-email', 'role' => 'form']) !!}
              <div class="row">

                  <div class="col-md-6">
                    <div class="form-group">
                        <input class="form-control"  required="required" name="cc"  type="email" id="cc" value=''>
                      <label for="name" class="form-label">CC</label>
                        <span class="form-controlBrd"></span>
                    </div>
                  </div>

                  <div class="col-md-6 ">
                    <div class="form-group">
                          <input class="form-control"   name="bcc" type="text"   id="bcc" value=''>
                      <label for="name" class="form-label">BCC</label>
                       <span class="form-controlBrd"></span>
                    </div>

                  </div>

              </div>
              {!! Form::close() !!}
          </div>

           <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-create-email" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
              {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-another-email', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
              </div>
          </div>
      </div>
   </div>
</div>
 @php 
function productservice1($elements, $prefix = '' , $item_id) {
    foreach ($elements as $k=> $element) { 
        @endphp
        <option value="{{ $element['id'] }}" 
        {{ ( $item_id == $element['id'] )?'selected':'' }}>
            {{ $prefix . $element['name'] }} 
            @if (isset($element['children']))
                @php productservice1($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $item_id);
                @endphp
            @endif
        </option>
    @php  } 
}
@endphp
<div id='productandservice_dropdown' style="display: none">
   <?php echo productservice1($items , $prefix = '', 0 );?>
</div>          
        

@endsection

@push('js')
    <script src="{{ asset('js/sortable/moment.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<!--affix script  -->
<script type="text/javascript">
            window.Laravel = $('meta[name="csrf-token"]').attr('content');
            $(".alert").fadeTo(2000, 500).slideUp(500, function(){
                $(".alert").slideUp(4000);
            });
            function getWeekData() { }            
            // Table Header affix
            $(document).ready(function() {
                var toggleAffix = function(affixElement, scrollElement, wrapper) {  
                    var height = affixElement.outerHeight(),
                    top = wrapper.offset().top;    
                    if (scrollElement.scrollTop() >= top){
                        wrapper.height(height);
                        affixElement.addClass("affix");
                        $( "table" ).addClass("affixTable");
                    }
                    else {
                        affixElement.removeClass("affix");
                        wrapper.height('auto');
                    }      
                }  

                $('[data-toggle="affix"]').each(function() {
                    var ele = $(this),
                    wrapper = $('<div></div>');

                    ele.before(wrapper);
                    $(window).on('scroll resize', function() {
                        toggleAffix(ele, $(this), wrapper);
                    });

                    // init
                    toggleAffix(ele, $(window), wrapper);
                });
            });    
        </script>
        
<!-- end -->

@endpush


@push('scripts')


 <script type="text/javascript">

        var item_row = '{{ $item_row }}';

        
        function addItem() {
            html  = '<tr id="item-row-' + item_row + '">';
            html += '  <td  style="vertical-align: middle;">';
            html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
            html += '  </td>';

            html += '  <td>';
            html += '<select class="selectpicker" onchange="autoItem('+ item_row +')" name="item[' + item_row + '][item_id]" required="required" id="item-id-' + item_row + '"  data-live-search="true">';
             html += '<option selected="selected" value="">{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}</option>';

            html += $('#productandservice_dropdown').html();
            html += '</select>';
            html += '<input class="form-control"  name="item['+ item_row +'][name]"        type="hidden" id="item-name-'+ item_row + '">';
            html += '<input class="form-control"   name="item['+ item_row +'][chartid]" type="hidden" id="item-chartid-'+item_row +'">';
            html += '  </td>';
            html +=' <td>';
            html += '<div class="form-group">';
            html += '<input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">';
            html +=  '<label class="form-label">{{  trans('general.description') }} </label>';
            html += '<span class="form-controlBrd"></span>'
            html += '</div></td>';
            html += '  <td>';
            html += ' <div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][quantity]" type="text" id="item-quantity-' + item_row + '"><label class="form-label">Quantity</label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td>';
            html += '<div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td style="vertical-align: middle;">';
            html += '      <span id="item-total-' + item_row + '">0</span>';
            html += '  </td></tr>';

            $('#items tbody #addItem').before(html);

            $('#item-id-'+ item_row).selectpicker('refresh');

            item_row++;
        }
        var autocomplete_path = "{{ url('items/items/autocompletebill') }}";
        function autoItem (id){
           
            var item_id = $("#item-id-"+id).val();
            var employee_id = $('#customer_timesheet').val();
            
            if(employee_id != "0" && employee_id != ''){
                $('#timesheetdetails').html('');
                $.ajax({
                    type:'GET',
                    dataType :'JSON',
                    url:'{{ url('payrole/timesheetdetails') }}'+'/'+employee_id,
                    success:function(data){
                        if(data){
 
                            html = '<div class="card">{!! Form::open(['id' => 'form-create-timesheet', 'role' => 'form']) !!}<div class="card-header"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="sendlater" id="timesheet_check_all" value="1" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description" style="margin-left:-7.2rem;"> Check All</span> </label> </div></div><div class="row"> <input type="hidden" value="{{ csrf_token() }}" name="_token"><input type="hidden" value="'+id+'"  id="item_id"  name="item_id">';

                            var array_convert =  [];
                            $("input[name='approved_days_array[]']").each(function(){
                                value = this.value.split(',');
                                if(value.length > 0){
                                    $.each(value,function(i,v){
                                        array_convert.push(v);
                                    });
                                }else{
                                    array_convert.push(this.value);
                                }
                            });  
                            $.each(data,function(index,value){
                                var approved_days = $.parseJSON(value.approved_days);
                                var approved_daysot = $.parseJSON(value.approved_daysot);
                                if(value.monday !== null && typeof(value.monday) !== 'undefined'){ 
                                    var monday = $.parseJSON(value.monday);
                                    if(monday.WH != 0 && approved_days.monday != 'approved' && array_convert.length >= 0 && $.inArray('monday_'+value.id,array_convert) === -1){
                                            html  += '<div class="col-lg-2 col-md-2 col-sm-2">';
                                            html  += '<div class="card-DboardStats flex-column  text-center"> <div><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="monday_'+value.id+'" value="'+monday.WH+'" class="overflow-control-input"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+monday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Monday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                            html += '</div>';  

                                    }if(monday.OT != 0 && approved_daysot.mondayot != 'approved' && array_convert.length >= 0 && $.inArray('monday_ot_'+value.id,array_convert) === -1){
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"> <div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="monday_ot_'+value.id+'" value="'+monday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+monday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Monday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>'; 
                                    }
                                }if(value.tuesday !== null && typeof(value.tuesday) !== 'undefined'){ 
                                    var tuesday = $.parseJSON(value.tuesday); 
                                    if(tuesday.WH != 0 && approved_days.tuesday != 'approved' && array_convert.length >= 0 && $.inArray('tuesday_'+value.id,array_convert) === -1){
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="tuesday_'+value.id+'" value="'+tuesday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+tuesday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Tuesday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(tuesday.OT != 0 && approved_daysot.tuesdayot != 'approved' && array_convert.length >= 0 && $.inArray('tuesday_ot_'+value.id,array_convert) === -1){
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="tuesday_ot_'+value.id+'" value="'+tuesday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+tuesday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Tuesday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }if(value.wednesday !== null && typeof(value.wednesday) !== 'undefined'){ 
                                    var wednesday = $.parseJSON(value.wednesday);
                                    if(wednesday.WH != 0 && approved_days.wednesday != 'approved' && array_convert.length >= 0 && $.inArray('wednesday_'+value.id,array_convert) === -1){
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="wednesday_'+value.id+'" value="'+wednesday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+wednesday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Wednesday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(wednesday.OT != 0 && approved_daysot.wednesdayot != 'approved' && array_convert.length >= 0 && $.inArray('wednesday_ot_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="wednesday_ot_'+value.id+'" value="'+wednesday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+wednesday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Wednesday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }if(value.thursday !== null && typeof(value.thursday) !== 'undefined'){ 
                                    var thursday = $.parseJSON(value.thursday);
                                    if(thursday.WH != 0 && approved_days.thursday != 'approved' && array_convert.length >= 0 && $.inArray('thursday_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="thursday_'+value.id+'" value="'+thursday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+thursday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Thursday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(thursday.OT != 0 && approved_daysot.thursdayot != 'approved' && array_convert.length >= 0 && $.inArray('thursday_ot_'+value.id,array_convert) === -1){
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column mb-0 text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="thursday_ot_'+value.id+'" value="'+thursday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+thursday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Thursday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }if(value.friday !== null && typeof(value.friday) !== 'undefined'){ 
                                    var friday = $.parseJSON(value.friday);
                                    if(friday.WH != 0 && approved_days.friday != 'approved' && array_convert.length >= 0 && $.inArray('friday_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="friday_'+value.id+'" value="'+friday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+friday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Friday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(friday.OT != 0 && approved_daysot.fridayot != 'approved' && array_convert.length >= 0 && $.inArray('friday_ot_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">';
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="friday_ot_'+value.id+'" value="'+friday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+friday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Friday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }if(value.saturday !== null && typeof(value.saturday) !== 'undefined'){ 
                                    var saturday = $.parseJSON(value.saturday);
                                    if(saturday.WH !=0 && approved_days.saturday != 'approved' && array_convert.length >= 0 && $.inArray('saturday_'+value.id,array_convert) === -1){

                                      html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="saturday_'+value.id+'" value="'+saturday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+saturday.WH)+':00 REG</span> <span class="inv-text">'+moment().day("Saturday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(saturday.OT != 0 && approved_daysot.saturdayot != 'approved' && saturday.length >= 0 && $.inArray('saturday_ot_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="saturday_ot_'+value.id+'" value="'+saturday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+saturday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Saturday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }if(value.sunday !== null && typeof(value.sunday) !== 'undefined'){ 
                                    var sunday = $.parseJSON(value.sunday);
                                    if(sunday.WH && approved_days.sunday != 'approved' && array_convert.length >=0 && $.inArray('sunday_'+value.id,array_convert) === -1){ 
                                        html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="sunday_'+value.id+'" value="'+sunday.WH+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+sunday.WH)+':00 OT</span> <span class="inv-text">'+moment().day("Sunday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }if(sunday.OT && approved_daysot.sundayot != 'approved' && sunday.length >=0 && $.inArray('sunday_ot_'+value.id,array_convert) === -1){ 
                                       html  += '<div class="col-lg-2 col-md-2 col-sm-2">'; 
                                        html  += '<div class="card-DboardStats flex-column  text-center"> <div class="" data-toggle="tooltip" data-placement="top" title="this is tooltip"><div class="custom-controls-stacked d-block" > <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="sunday_ot_'+value.id+'" value="'+sunday.OT+'" class="overflow-control-input" data-dirrty-initial-value="unchecked"> <span class="overflow-control-indicator" ></span> <span class="overflow-control-description"></span> </label> </div> <span class="inv-amount">'+ (+sunday.OT)+':00 OT</span> <span class="inv-text">'+moment().day("Sunday").isoWeek(value.week_value).year(value.year_value).format("MM-DD-YYYY")+'</span> </div> </div> ';
                                        html += '</div>';
                                    }
                                }
                            });

                            html  += '{!! Form::close() !!}</div><div class="pull-left"> <button type="button" id="close-modal-timesheet" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button> {!! Form::button('Add', ['type' => 'button', 'id' =>'button-create-timesheet', 'class' => 'btn btn-primary waves-effect waves-light']) !!} </div></div>';

                            $('#timesheetdetails').append(html);


                        }
                    }
                });
            }

            
            //console.log(quantity);
            $.ajax({
                url: autocomplete_path,
                type: 'GET',
                dataType: 'JSON',
                data: 'query=' + item_id + '&type=invoice&currency_code=' + $('#currency_code').val(),
                success: function(data) {
                    var quantity = $('#item-quantity-' + id).val();
                    $('#item-name-'+id).val(data.name);
                    $('#item-quantity-' + id).val('1');
                    $('#item-price-' + id).val(data.sale_price);
                    $('#item-chartid-' +id).val(data.income_account);
                    $('#item-total-' + id).html(data.total);
                    totalItem(); 
                }
            });
        }
  
       
        $(document).ready(function(){

            $('#net_term').on('change',function(){
                var term_id = $(this).val();
                var invoiced_at = $('#invoiced_at').val().replace(/-/g,'/'); 
                if(term_id){
                    $.ajax({
                        type: 'GET',
                        dataType: 'JSON',
                        url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
                        success:function(data){
                         
                            if(data.term_days == 0){
                                var netterm = data.term_days;
                            }else{
                                var netterm = (data.term_days - 1);
                            }
                            var dt = new Date(invoiced_at);
                            dt.setDate(dt.getDate() + +netterm); //console.log(dt);
                            var date = gj.core.formatDate(dt,'{{ $date_format }}');
                            $("#due_at").val(date);

                        },
                        error:function(error){
                            console.log(error);
                        }
                    });
                }
            });


            $('#subcustomer').on('change',function(){
                if(this.checked){
                    $('#customer_id_save').removeAttr('disabled');
                    $('#bill_to').removeAttr('disabled');
                }else{
                    $('#customer_id_save').attr('disabled','disabled');
                    $('#bill_to').attr('disabled','disabled');
                };
                $('#customer_id_save').selectpicker('refresh');
                $('#bill_to').selectpicker('refresh');
            });

            //Date picker
            $('#invoiced_at').datepicker({
                format: '{{ $date_format }}',
                autoclose: true,
            });
            //Date picker
            $('#due_at').datepicker({
                format: '{{ $date_format }}',
                minDate: $('#invoiced_at').val(),
                autoclose: true
            });
            
            $('#invoiced_at').on('change',function(){
                var invoiced_at = $(this).val();
                var term_id = $('#net_term').val();
                if(term_id){
                    $.ajax({
                        type: 'GET',
                        dataType: 'JSON',
                        url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
                        success:function(data){
                         
                            if(data.term_days == 0){
                                var netterm = data.term_days;
                            }else{
                                var netterm = (data.term_days - 1);
                            }
                            var dt = new Date(invoiced_at);
                            dt.setDate(dt.getDate() + +netterm); //console.log(dt);
                            var date = gj.core.formatDate(dt,'{{ $date_format }}');
                            $("#due_at").datepicker("destroy");
                            $("#due_at").addClass('form-control has-value');
                            $('#due_at').datepicker({
                                format: '{{ $date_format }}',
                                minDate: invoiced_at,
                                autoclose: true
                            });
                            $("#due_at").val(date);
                        },
                        error:function(error){
                            console.log(error);
                        }
                    });
                }

            });


            $(document).on('change', '#currency_code, #items tbody select', function(){
                totalItem();
            });

            $(document).on('keyup', '#items tbody .form-control', function(){
                totalItem();
            });

            var customer_id = $('#customer_id').val();
            if(customer_id != ''){
                autocompletecustomer(customer_id);
            }
            $('#customer_id').on('change',function(){
                var val = $(this).val();
                autocompletecustomer(val);
                showtimecard(val);
            });

            $('#same_as_billingvalue').change(function(){
                var c = this.checked;
                $('#shipping_address_customer').prop('disabled', c);
                if(c){ 
                    $('#shipping_address_customer').val($('#address1').val());
                    $('#shipping_address_customer').addClass('has-value');
                }else{
                     $('#shipping_address_customer').val('');
                       $('#shipping_address_customer').removeClass('has-value');
                }
            });


        });

        // $(document).on('change','#same_as_billingvalue',function(e){
        //     alert();
        // });

        $(document).on('click', '#button-create-customer', function (e) {
            $('#modal-create-customer .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

            $.ajax({
                url: '{{ url("incomes/customers/customer") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $("#form-create-customer").serialize(),
                beforeSend: function () {
                    $(".form-group").removeClass("has-error");
                    $(".help-block").remove();
                },
                success: function(data) {
                    autocompletecustomer(data.id);
                    $('#span-loader').remove();
                    $('#close-modal-create-customer').trigger('click');
                    $("#customer_id").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');

                    $("#customer_id").selectpicker('refresh');
                },
                error: function(error, textStatus, errorThrown) {
                    console.log(error);
                    $('#span-loader').remove();

                    if (error.responseJSON.customer_email) {
                        $("input[name='customer_email']").parent().parent().addClass('has-error');
                        $("input[name='customer_email']").parent().after('<p class="help-block">' + error.responseJSON.customer_email + '</p>');
                    }

                    if (error.responseJSON.currency_code) {
                        $("select[name='currency_code']").parent().parent().addClass('has-error');
                        $("select[name='currency_code']").parent().after('<p class="help-block">' + error.responseJSON.currency_code + '</p>');
                    }
                }
            });
        });
        $(document).on('click', '#button-create-timesheet', function (e) {
             
            $('#timesheetdetails').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

            let item_id =  $('#item_id').val();
            var approved_days = [];
            var value  = 0;
            let html  = '';
            let approved_days_html  = '';
            $("input[name='approvetimesheet[]']").each(function(){
                if(this.checked){
                    approved_days.push(this.id);
                    var id = this.id;
                    value += parseInt($(this).val());
                    $('#'+id).closest("tr").remove();
                }
            }); 
            
             approved_days_html =  '<input class="form-control" name="approved_days_array[]" id="item-approvedays-'+item_id+'" type="hidden"   value="'+approved_days+'">';
            $('#item-row-'+item_id).append(approved_days_html);
            $('#item-quantity-'+item_id).val(value);
            $('#span-loader').remove();
            $('#timesheetdetails').html('');
            totalItem();
        });

        $(document).on('change','#timesheet_check_all',function(){
            $("input[name='approvetimesheet[]']").prop('checked',this.checked); 
        });

        // $(document).on('change', '#same_as_billing', function(e){
        //     var c = this.checked;

        //     $(".shipping_address").prop('disabled', c);
        //     if(c){
        //     $(".shipping_address").val($('#address1').val());
        //     }else{
        //      $(".shipping_address").val('');
        //     }
        // });



        $(document).on('click', '#button-create-term', function (e) {
            $('#modal-create-term .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

            $.ajax({
                url: '{{ url("/netterms/terms") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $("#form-create-term").serialize(),
                beforeSend: function () {
                    $(".form-group").removeClass("has-error");
                    $(".help-block").remove();
                },
                success: function(data) {
                    $('#span-loader').remove();
                    $('#close-modal-create-term').trigger('click');
                    $("#net_term").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
                    $("#net_term").selectpicker('refresh');
                },
                error: function(error, textStatus, errorThrown) {
                    $('#span-loader').remove();
                }
            });
        });

        $(document).on('click', '#button-another-email', function(e){
            $('#modal-another-email .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');
                var cc = $('#cc').val();
                var bcc = $('#bcc').val();

                var cc_count = $('#cc').val().split(',');
                var bcc_count = $('#bcc').val().split(',');
            

                if (cc ){
                    $('#cc_email').val(cc);
                    $('#cc_count').html( '(' + cc_count.length + ')').show();
                    $(".form-group").removeClass("has-error");
                    $(".help-block").remove();   
                } 
                if (bcc){
                    $('#bcc_email').val(bcc);
                    $('#bcc_count').html( '(' + bcc_count.length + ')').show();
                    $(".form-group").removeClass("has-error");
                    $(".help-block").remove();
                }
                $('#close-modal-create-email').trigger('click');
                $('#span-loader').remove();
        });

        function autocompletecustomer(customer_id){
            $('#timesheetdetails').html('');
            $.ajax({
                    type: 'GET',
                    dataType: 'JSON',
                    data: 'customer_id=' +customer_id,
                    url : '{{ url('incomes/customers/autocompletecustomer') }}',
                    success:function(data){
                       $('#select2-customer_id-container').html(data.full_details.original.full_name);
                       $('#net_term').val(data.customer.net_term);
                       $('#net_term').selectpicker('refresh');
                       // This event Select2 Stylesheet
                       $('#net_term').trigger("change");
                       $('#customer_email').val(data.customer.customer_email).addClass('has-value');
                       $('#address').val(data.customer.address).addClass('has-value');
                       $('#shipping_address').val(data.customer.shipping_address).addClass('has-value');
                       if(data.customer.consultant){
                        $('#customer_timesheet').val(data.customer.consultant);                     
                       }else{
                        $('#customer_timesheet').val('0');                     
                       }
                        if(data.customer.cc_email){
                            $('#cc_email').val(data.customer.cc_email);
                            $('#cc_count').html( '(' + '1' + ')').show();
                        }else{
                            $('#cc_email').val();
                            $('#cc_count').hide();
                        }
                        if(data.customer.bill_to==='parent'){
                            $('#customer_invoice_parent_id').val(data.parent_id);
                        }else{
                            $('#customer_invoice_parent_id').val(data.customer.id);
                        }
                    },
                    error:function(error){
                        console.log(error);
                    }
                });
        }


        function showtimecard(customer_id){
            $('#time_card').html('');
            $.ajax({
                url :'{{ url('payrole/timecard') }}'+'/'+customer_id,
                success:function(data){
                    if(data){


                       html = '<h3 class="item-title">Time Cards</h3><div class="View-TimeSheet"><table class="table table-bordered " id="sum_table"> <thead> <tr> <th style="width:15%;">Summary <small>Month-Year</small> </th>';
                           for(i=1;i<32;i++ ){
                            html +=   '<th class="tablemiddel">'+i+'</th>';
                           } 
                        html +=  '</tr> </thead>';

                        html += '<tbody class="scheduleTable">';
                        $.each(data,function(i,value){
                            html +='<tr> <td class="new_event_class" rowspan="2"> <span class="SchTbtmBrd"> <span class="label label-default view_event">'+moment(value.month_value+'-10-'+value.year_value).format('MMM-YYYY') +'</span></span> </td>';
                                for(j=1 ;j < 32 ; j++ ){
                                    var present_day = "day"+j;
                                    if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
                                        parse_value = $.parseJSON(value[present_day]);
                                     html += '<td>'+ addZeroes(parse_value.WH) +'</td>';
                                    }else{ html += '<td>-</td>'; }
                                } 
                            html +='<tr>  </td>';
                                for(j=1 ;j < 32 ; j++ ){
                                    var present_day = "day"+j;
                                    if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
                                        parse_value = $.parseJSON(value[present_day]);
                                     html += '<td>'+ addZeroes(parse_value.OT) +'</td>';
                                    }else{ html += '<td>-</td>'; }
                                }
                           

                        });

                        html +=  '</tbody> </table></div>';

                        $('#time_card').append(html);


                    }

                },
                error:function(){

                }
            });
        }

        $(document).ajaxStart(function(){
            $("#wait").css("display", "block");
        });
        $(document).ajaxComplete(function(){
            $("#wait").css("display", "none");
        });


   
               
        function totalItem() {
            $.ajax({
                url: '{{ url("items/items/totalItem") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select'),
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                success: function(data) {
                    if (data) {
                        $.each( data.items, function( key, value ) {
                            $('#item-total-' + key).html(value);
                        });

                        $('#sub-total').html(data.sub_total);
                        $('#grand-total').html(data.grand_total);
                    }
                }
            });
        }

        function format(input) {
            var date = new Date(input);
            return [
               date.getFullYear(),
               ("0" + (date.getMonth()+1)).slice(-2),
               ("0" + date.getDate()).slice(-2)
            ].join('-');
        }

       function checkForInput(element) {
          // element is passed to the function ^
          
          const $label = $(element).siblings('label');

          if ($(element).val().length > 0) {
            $element.addClass('has-value');
          } else {
            $element.removeClass('has-value');
          }
        }
  // The lines below are executed on page load
$('input.form-control').each(function() {
  checkForInput(this);
});

// The lines below (inside) are executed on change & keyup
$('input.form-control').on('change keyup', function() {
  checkForInput(this);  
});

 /* Add  Zeros To Numbers*/
    function addZeroes( num ) {
        var value = Number(num);
        var res = num.split(".");
        if(res.length == 1 || (res[1].length < 3)) {
            value = value.toFixed(2);
        }
        return value
    }
</script>
@endpush
